import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Query,
} from '@nestjs/common';
import { CategoryEvidenceService } from './category-evidence.service';
import { CreateCategoryEvidenceDto } from './dto/create-category-evidence.dto';
import { UpdateCategoryEvidenceDto } from './dto/update-category-evidence.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Controller('category-evidence')
export class CategoryEvidenceController {
  constructor(
    private readonly categoryEvidenceService: CategoryEvidenceService,
  ) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  create(@Body() dto: CreateCategoryEvidenceDto) {
    return this.categoryEvidenceService.create(dto);
  }

  @Get('list/:categoryId')
  findAllByCategory(
    @Param('categoryId') categoryId: string,
    @Query() dto: CommonPaginationDto,
  ) {
    return this.categoryEvidenceService.findAll(categoryId, dto);
  }

  @Patch('update/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  update(@Param('id') id: string, @Body() dto: UpdateCategoryEvidenceDto) {
    return this.categoryEvidenceService.update(id, dto);
  }

  @Delete('remove/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  remove(@Param('id') id: string) {
    return this.categoryEvidenceService.remove(id);
  }
}
