import { Game } from 'src/game/entities/game.entity';
import { UserCase } from 'src/user-case/entities/user-case.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  CreateDateColumn,
  UpdateDateColumn,
  Column,
  ManyToOne,
  OneToMany,
} from 'typeorm';

@Entity()
export class Case {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  gameId: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  question: string;

  @Column({ type: 'text', nullable: true })
  qImage: string;

  @Column({ type: 'text', nullable: true })
  qImagePath: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  hint: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans1: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans2: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans3: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans4: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans1Image: string;
  @Column({ type: 'varchar', length: 500, nullable: true })
  ans1ImagePath: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans2Image: string;
  @Column({ type: 'varchar', length: 500, nullable: true })
  ans2ImagePath: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans3Image: string;
  @Column({ type: 'varchar', length: 500, nullable: true })
  ans3ImagePath: string;

  @Column({ type: 'varchar', length: 500, nullable: true })
  ans4Image: string;
  @Column({ type: 'varchar', length: 500, nullable: true })
  ans4ImagePath: string;

  @Column({ type: 'varchar', length: 10, nullable: true })
  correctAnsNum: string;

  @Column({ type: 'int', nullable: true })
  winPoint: number;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Game, (game) => game.case, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  game: Game[];

  @OneToMany(() => UserCase, (userCase) => userCase.case)
  userCase: UserCase[];
}
