import { Module } from '@nestjs/common';
import { CaseService } from './case.service';
import { CaseController } from './case.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Case } from './entities/case.entity';
import { AuthModule } from 'src/auth/auth.module';
import { UserCase } from 'src/user-case/entities/user-case.entity';

@Module({
  imports: [TypeOrmModule.forFeature([Case, UserCase]), AuthModule],
  controllers: [CaseController],
  providers: [CaseService],
})
export class CaseModule {}
