import { CoinHistory } from 'src/coin-history/entities/coin-history.entity';
import { ContactUs } from 'src/contact-us/entities/contact-us.entity';
import {
  AIType,
  DefaultStatus,
  LoginType,
  PlayerBadge,
  UserRole,
} from 'src/enum';
import { Feedback } from 'src/feedback/entities/feedback.entity';
import { LeaderboardMonthly } from 'src/leaderboard-monthly/entities/leaderboard-monthly.entity';
import { LoginHistory } from 'src/login-history/entities/login-history.entity';
import { Notification } from 'src/notifications/entities/notification.entity';
import { PaymentHistory } from 'src/payment-history/entities/payment-history.entity';
import { PlanHistory } from 'src/plan-history/entities/plan-history.entity';
import { Plan } from 'src/plan/entities/plan.entity';
import { Setting } from 'src/settings/entities/setting.entity';
import { StaffDetail } from 'src/staff-details/entities/staff-detail.entity';
import { UserCase } from 'src/user-case/entities/user-case.entity';
import { UserCategory } from 'src/user-category/entities/user-category.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import { UserGame } from 'src/user-game/entities/user-game.entity';
import { UserPermission } from 'src/user-permissions/entities/user-permission.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  JoinColumn,
  OneToMany,
  OneToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Account {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  planId: string;

  @Column({ type: 'int', default: 0 })
  totalCoin: number;

  @Column({ type: 'int', default: 0 }) // Global Point
  totalPoint: number;

  // @Column({ type: 'int', default: 0 })
  // monthlyTotalPoint: number;

  @Column({ type: 'int', default: 0 })
  totalXP: number;

  // @Column({ type: 'int', default: 0 })
  // monthlyXP: number;

  @Column({ type: 'enum', enum: PlayerBadge, default: PlayerBadge.Rookie })
  badge: PlayerBadge;

  @Column({ type: 'varchar', length: 100, nullable: true })
  phoneNumber: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  email: string;

  @Column({ type: 'text', nullable: true })
  password: string;

  @Column({ type: 'enum', enum: UserRole, default: UserRole.USER })
  roles: UserRole;

  // @Column({ type: 'varchar', length: 100, nullable: true })
  // deviceId: string;

  // @Column({ type: 'enum', enum: LoginType, default: LoginType.PHONE })
  // type: LoginType;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @Column({ type: 'varchar', length: 5000, nullable: true })
  reason: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  referralCode: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  referredBy: string;

  @Column({ type: 'date', nullable: true })
  subscriptionStartDate: string;

  @Column({ type: 'date', nullable: true })
  subscriptionEndDate: string;

  @Column({ type: 'date', nullable: true })
  lastFreeCoinDate: string;

  @Column({ type: 'int', default: 0 })
  winStreak: number;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => LoginHistory, (loginHistory) => loginHistory.account)
  loginHistory: LoginHistory[];

  @OneToMany(() => Notification, (notification) => notification.account)
  notification: Notification[];

  @OneToMany(() => UserPermission, (userPermission) => userPermission.account)
  userPermission: UserPermission[];

  @OneToMany(() => UserDetail, (userDetail) => userDetail.account)
  userDetail: UserDetail[];

  @OneToMany(() => StaffDetail, (staffDetail) => staffDetail.account)
  staffDetail: StaffDetail[];

  @OneToMany(() => PaymentHistory, (paymentHistory) => paymentHistory.account)
  paymentHistory: PaymentHistory[];

  @OneToMany(() => Feedback, (feedback) => feedback.account)
  feedback: Feedback[];

  @OneToMany(() => ContactUs, (contactUs) => contactUs.account)
  contactUs: ContactUs[];

  @OneToMany(() => UserCategory, (userCategory) => userCategory.account)
  userCategory: UserCategory[];

  @OneToMany(() => UserGame, (userGame) => userGame.account)
  userGame: UserGame[];

  @OneToMany(() => UserCase, (userCase) => userCase.account)
  userCase: UserCase[];

  @OneToMany(() => PlanHistory, (planHistory) => planHistory.account)
  planHistory: PlanHistory[];

  @OneToMany(() => CoinHistory, (coinHistory) => coinHistory.account)
  coinHistory: CoinHistory[];

  @OneToMany(
    () => LeaderboardMonthly,
    (leaderboardMonthly) => leaderboardMonthly.account,
  )
  leaderboardMonthly: LeaderboardMonthly[];

  @JoinColumn()
  @OneToOne(() => Plan, (plan) => plan.account)
  plan: Plan[];
}
