import { City } from 'src/city/entities/city.entity';
import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { CompanyDetail } from 'src/company-details/entities/company-detail.entity';
import { Column, Entity, OneToMany, PrimaryGeneratedColumn } from 'typeorm';

@Entity()
export class State {
  @PrimaryGeneratedColumn('increment')
  id: number;

  @Column({ type: 'varchar', length: 100 })
  name: string;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @OneToMany(() => City, (city) => city.state)
  city: City[];

  @OneToMany(() => OutletDetail, (outletDetail) => outletDetail.state)
  outletDetail: OutletDetail[];

  @OneToMany(() => OutletBranch, (outletBranch) => outletBranch.state)
  outletBranch: OutletBranch[];

  @OneToMany(() => CompanyDetail, (companyDetail) => companyDetail.state)
  companyDetail: CompanyDetail[];
}
