import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { OutletCategoryDto, BoolStatusDto } from './dto/outlet-category.dto';
import { OutletCategory } from './entities/outlet-category.entity';

@Injectable()
export class OutletCategoryService {
  constructor(
    @InjectRepository(OutletCategory)
    private readonly repo: Repository<OutletCategory>,
  ) {}

  async create(dto: OutletCategoryDto) {
    JSON.parse(dto.categoryId).forEach(async element => {
      const result = await this.repo.findOne({
        where: {
          outletBranchId: dto.outletBranchId,
          categoryId: element.id,
        },
      });
      let createDate = {categoryId: element.id, outletBranchId: dto.outletBranchId};
      if (result) {
        throw new ConflictException('Already exists!');
      }
      const obj = Object.create(createDate);
      this.repo.save(obj);
    });
    return true;
  }

  async findAll(outletBranchId: string) {
    const result = await this.repo
      .createQueryBuilder('OutletCategory')
      .leftJoinAndSelect('OutletCategory.category', 'category')
      .where('OutletCategory.outletBranchId = :outletBranchId', {
        outletBranchId: outletBranchId,
      })
      .getMany();
    return { result };
  }

  async status(id: string, dto: BoolStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return this.repo.remove(result);
  }
}
