import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Notification } from 'src/notifications/entities/notification.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { Order } from 'src/orders/entities/order.entity';
import { CronNotifyService } from './cron-notify.service';
import { NotifyController } from './notify.controller';
import { NotifyService } from './notify.service';

@Module({
  imports: [TypeOrmModule.forFeature([Notification, OutletDetail, Order])],
  controllers: [NotifyController],
  providers: [NotifyService, CronNotifyService],
  exports: [NotifyService, CronNotifyService],
})
export class NotifyModule {}
