import { ApiProperty } from '@nestjs/swagger';
import {
  IsEmail,
  IsNotEmpty,
  IsOptional,
  MaxLength,
  MinLength,
} from 'class-validator';

export class CreateContactUsDto {
  @ApiProperty()
  @IsNotEmpty()
  @IsEmail()
  @MinLength(5)
  @MaxLength(50)
  email: string;

  @ApiProperty()
  @IsNotEmpty()
  @MinLength(10)
  @MaxLength(20)
  phone: string;

  @ApiProperty()
  @IsNotEmpty()
  @MinLength(5)
  @MaxLength(200)
  subject: string;

  @ApiProperty()
  @IsNotEmpty()
  @MinLength(5)
  @MaxLength(3000)
  body: string;
}

export class UpdateContactUsDto {
  @ApiProperty()
  @IsNotEmpty()
  @MinLength(5)
  @MaxLength(3000)
  answer: string;

  @IsOptional()
  accountId: string;
}
