import { CompanyDetail } from 'src/company-details/entities/company-detail.entity';
import { SubCategory } from 'src/sub-category/entities/sub-category.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class CompanySubCategory {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  companyDetailId: string;

  @Column({ type: 'uuid', nullable: true })
  subCategoryId: string;

  @Column({ type: 'boolean', default: true })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(
    () => CompanyDetail,
    (companyDetail) => companyDetail.companySubCategory,
    {
      cascade: true,
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    },
  )
  companyDetail: CompanyDetail[];

  @ManyToOne(
    () => SubCategory,
    (subCategory) => subCategory.companySubCategory,
    {
      cascade: true,
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    },
  )
  subCategory: SubCategory[];
}
