import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { CompanySubCategoryController } from './company-sub-category.controller';
import { CompanySubCategoryService } from './company-sub-category.service';
import { CompanySubCategory } from './entities/company-sub-category.entity';

@Module({
  imports: [TypeOrmModule.forFeature([CompanySubCategory]), AuthModule],
  controllers: [CompanySubCategoryController],
  providers: [CompanySubCategoryService],
  exports: [CompanySubCategoryService],
})
export class CompanySubCategoryModule {}
