import {
  Body,
  Controller,
  Delete,
  Param,
  Post,
  Put,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiOperation } from '@nestjs/swagger';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CompanyCategoryService } from './company-category.service';
import { CompanyCategoryDto, BoolStatusDto } from './dto/company-category.dto';

@Controller('company-category')
export class CompanyCategoryController {
  constructor(
    private readonly companyCategoryService: CompanyCategoryService,
  ) {}

  @Post(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  create(@Param('id') id: string, @Body() dto: CompanyCategoryDto) {
    dto.companyDetailId = id;
    return this.companyCategoryService.create(dto);
  }

  @Put(':id')
  @ApiOperation({ summary: 'For Admin' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  status(@Param('id') id: string, @Body() dto: BoolStatusDto) {
    return this.companyCategoryService.status(id, dto);
  }

  @Delete(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  remove(@Param('id') id: string) {
    return this.companyCategoryService.remove(id);
  }
}
