import { Area } from 'src/area/entities/area.entity';
import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { CompanyDetail } from 'src/company-details/entities/company-detail.entity';
import { State } from 'src/state/entities/state.entity';
import {
  Column,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';

@Entity()
export class City {
  @PrimaryGeneratedColumn('increment')
  id: number;

  @Column({ type: 'varchar', length: 100 })
  name: string;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @Column({ type: 'int' })
  stateId: number;

  @ManyToOne(() => State, (state) => state.city, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  state: State[];

  @OneToMany(() => Area, (area) => area.city)
  area: Area;

  @OneToMany(() => OutletDetail, (outletDetail) => outletDetail.city)
  outletDetail: OutletDetail;

  @OneToMany(() => OutletBranch, (outletBranch) => outletBranch.city)
  outletBranch: OutletBranch;

  @OneToMany(() => CompanyDetail, (companyDetail) => companyDetail.city)
  companyDetail: CompanyDetail[];
}
