import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';

import { MulterModule } from '@nestjs/platform-express';
import { AuthModule } from 'src/auth/auth.module';
import { OutletDetailsModule } from 'src/outlet-details/outlet-details.module';
import { RouteAssginLog } from './entities/route-assgin-log.entity';
import { RouteAssginLogController } from './route-assgin-log.controller';
import { RouteAssginLogService } from './route-assgin-log.service';
import { diskStorage } from 'multer';
import { NotifyModule } from 'src/notify/notify.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([RouteAssginLog]),
    AuthModule,
    OutletDetailsModule,
    NotifyModule,
    MulterModule.register({
      storage: diskStorage({
        destination: './uploads/orders', // specify the upload directory
        filename: (req, file, cb) => {
          const uniqueSuffix =
            Date.now() + '-' + Math.round(Math.random() * 1e9);
          cb(null, `${uniqueSuffix}-${file.originalname}`);
        },
      }),
    }),
  ],
  controllers: [RouteAssginLogController],
  providers: [RouteAssginLogService],
})
export class RouteAssginLogModule {}
