import { Category } from 'src/category/entities/category.entity';
import { CompanyDetail } from 'src/company-details/entities/company-detail.entity';
import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class OutletCategory {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  outletBranchId: string;

  @Column({ type: 'uuid', nullable: true })
  categoryId: string;

  @Column({ type: 'boolean', default: true })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(
    () => OutletBranch,
    (outletBranch) => outletBranch.outletCategory,
    {
      cascade: true,
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    },
  )
  outletBranch: OutletBranch[];

  @ManyToOne(() => Category, (category) => category.outletCategory, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  category: Category[];
}
