import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { NotificationType } from 'src/enum';
import { Notification } from 'src/notifications/entities/notification.entity';
import { Order } from 'src/orders/entities/order.entity';
import {
  sendBulkNotifications,
  sendNotifications,
} from 'src/utils/notify.utils';
import { Repository } from 'typeorm';
import { CreateNotifyDto } from './dto/create-notify.dto';

@Injectable()
export class NotifyService {
  constructor(
    @InjectRepository(Notification)
    private readonly repo: Repository<Notification>,
    @InjectRepository(Order)
    private readonly oRepo: Repository<Order>,
  ) {}

  async loginNotify(fcm: string, accountId: string) {
    sendNotifications(
      fcm,
      'Thanks for login',
      'Thanks for login, Now you can order from our App.',
    );
    this.saveNotification({
      title: 'Thanks for login',
      desc: 'Thanks for login, Now you can order from our App.',
      type: NotificationType.ACCOUNT,
      redirectId: null,
      accountId: accountId,
    });
  }

  async loginDeliveryBoyNotify(fcm: string, accountId: string) {
    sendNotifications(
      fcm,
      'Thanks for login',
      'Thanks for login, Now you can check orders list for delivery.',
    );
    this.saveNotification({
      title: 'Thanks for login',
      desc: 'Thanks for login, Now you can check orders list for delivery.',
      type: NotificationType.ACCOUNT,
      redirectId: null,
      accountId: accountId,
    });
  }

  async loginBlockedNotify(fcm: string, accountId: string) {
    sendNotifications(
      fcm,
      'Blocked',
      'Your login is suspended by App Admin kindly contact to admin and resolve it.',
    );
    this.saveNotification({
      title: 'Blocked',
      desc: 'Your login is suspended by App Admin kindly contact to admin and resolve it.',
      type: NotificationType.ACCOUNT,
      redirectId: null,
      accountId: accountId,
    });
  }

  async outOfLocationNotify(fcm: string, accountId: string) {
    sendNotifications(
      fcm,
      'Out of location',
      'Hey we observe, you are not in Outlet. Please login from outlet Only.',
    );
    this.saveNotification({
      title: 'Out of location',
      desc: 'Hey we observe, you are not in Outlet. Please login from outlet Only.',
      type: NotificationType.ACCOUNT,
      redirectId: null,
      accountId: accountId,
    });
    return { result: 'true' };
  }

  async raiseTicket(fcm: string, accountId: string) {
    sendNotifications(
      fcm,
      'Concern raised',
      'Thanks for raising your concern, We are very excited to resolve your concern.',
    );
    this.saveNotification({
      title: 'Concern raised',
      desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
      type: NotificationType.ACCOUNT,
      redirectId: null,
      accountId: accountId,
    });
  }

  async timeIncrease(fcm: string, outletDetailId: string, cartId: string) {
    sendNotifications(
      fcm,
      'Time Increase',
      'Thanks for raising your concern, We are very excited to resolve your concern.',
    );
    this.saveNotification({
      title: 'Time Increase',
      desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
      type: NotificationType.TIME_INCREMENT,
      redirectId: outletDetailId,
      accountId: null,
    });

    this.oRepo
        .createQueryBuilder()
        .update()
        .set({
          tistatus: true,
        })
        .where('cartId = :cartId', { cartId: cartId })
        .execute();

    return { result: 'true' };
  }

  async timeIncreaseOutlet(fcm: string, outletDetailId: string) {
    sendNotifications(
      fcm,
      'Time Increase',
      'Thanks for raising your concern, We are very excited to resolve your concern.',
    );
    this.saveNotification({
      title: 'Time Increase',
      desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
      type: NotificationType.TIME_INCREMENT,
      redirectId: outletDetailId,
      accountId: null,
    });

    return { result: 'true' };
  }


  async timeIncreaseReply(fcm: string, accountId: string, outletDetailId: string) {
    sendNotifications(
      fcm,
      'Time Increase',
      'Thanks for raising your concern, We are very excited to resolve your concern.',
    );
    this.saveNotification({
      title: 'Time Increase',
      desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
      type: NotificationType.TIME_INCREMENT,
      redirectId: outletDetailId,
      accountId: accountId,
    });
  }

  async orderPlaced(
    fcm: string,
    orderId: string,
    date: string,
    accountId: string,
  ) {
    // get date only
    var fullDate = new Date(date);
    var tDate = fullDate.getDate();
    var tYear = fullDate.getFullYear();
    var tMonth = fullDate.getMonth() + 1;
    const delivery_date = tDate + '-' + tMonth + '-' + tYear;
    sendNotifications(
      fcm,
      'Order Placed',
      'Thanks for your order, your order ' +
        orderId +
        ' we will deliver your order ' +
        delivery_date +
        '.',
    );
    this.saveNotification({
      title: 'Order Placed',
      desc:
        'Thanks for your order, your order ' +
        orderId +
        ' we will deliver your order ' +
        delivery_date +
        '.',
      type: NotificationType.ORDER,
      redirectId: orderId,
      accountId: accountId,
    });
  }

  async orderConfirmed(
    fcm: string,
    orderId: string,
    date: string,
    accountId: string,
  ) {
    sendNotifications(
      fcm,
      'Order Confirmed',
      'Hey thanks for placing order ' +
        orderId +
        ' we will delivery order on dated ' +
        date +
        '.',
    );
    this.saveNotification({
      title: 'Order Confirmed',
      desc:
        'Hey thanks for placing order ' +
        orderId +
        ' we will delivery order on dated ' +
        date +
        '.',
      type: NotificationType.ORDER,
      redirectId: orderId,
      accountId: accountId,
    });
  }

  async lateOrderConfirmed(fcm: string, orderId: string, accountId: string) {
    sendNotifications(
      fcm,
      'Order Confirmed',
      'Hey thanks for placing order we will notify you once order confirm from Base Kitchen your order Number ' +
        orderId +
        '.',
    );
    this.saveNotification({
      title: 'Order Confirmed',
      desc:
        'Hey thanks for placing order we will notify you once order confirm from Base Kitchen your order Number ' +
        orderId +
        '.',
      type: NotificationType.ORDER,
      redirectId: orderId,
      accountId: accountId,
    });
  }

  async orderChanges(fcm: string, orderId: string, accountId: string) {
    sendNotifications(
      fcm,
      'Order Change',
      'Thanks for making the changes in order will notify to base kitchen.',
    );
    this.saveNotification({
      title: 'Order Change',
      desc: 'Thanks for making the changes in order will notify to base kitchen.',
      type: NotificationType.ORDER,
      redirectId: orderId,
      accountId: accountId,
    });
  }

  async orderBeforeTime(fcm: string, orderId: string, accountId: string) {
    sendNotifications(
      fcm,
      'Order Change',
      'Hey you can edit order you have 30 min left time.',
    );
    this.saveNotification({
      title: 'Order Change',
      desc: 'Hey you can edit order you have 30 min left time.',
      type: NotificationType.ORDER,
      redirectId: orderId,
      accountId: accountId,
    });
  }

  async appMaintenance() {
    sendBulkNotifications(
      'App under maintenance',
      'Hey we We put our app in maintenance for app upgradation.',
    );
    this.saveNotification({
      title: 'App under maintenance',
      desc: 'Hey we We put our app in maintenance for app upgradation.',
      type: NotificationType.MAINTENANCE,
      redirectId: null,
      accountId: null,
    });
  }

  private saveNotification(dto: CreateNotifyDto) {
    return this.repo.save(dto);
  }
}
