import { Controller, Get, Param } from '@nestjs/common';
import { NotifyService } from './notify.service';

@Controller('notify')
export class NotifyController {
  constructor(private readonly notifyService: NotifyService) {}

  @Get(':fcm/:accountId')
  outOfLocationNotify(@Param('fcm') fcm: string, @Param('accountId') accountId: string) {
    return this.notifyService.outOfLocationNotify(fcm, accountId);
  }

  @Get('time-increase/:fcm/:outletDetailId/:cartId')
  timeIncreaseNotify(
    @Param('fcm') fcm: string,
    @Param('outletDetailId') outletDetailId: string,
    @Param('cartId') cartId: string,
  ) {
    return this.notifyService.timeIncrease(fcm, outletDetailId, cartId);
  }

  @Get('outlet-time-increase/:fcm/:outletDetailId')
  timeIncreaseOutletNotify(
    @Param('fcm') fcm: string,
    @Param('outletDetailId') outletDetailId: string,
  ) {
    return this.notifyService.timeIncreaseOutlet(fcm, outletDetailId);
  }
}
