import { Controller, Get, Query } from '@nestjs/common';
import { DashboardService } from './dashboard.service';

@Controller('dashboard')
export class DashboardController {
  constructor(private readonly dashboardService: DashboardService) {}

  @Get()
  async dashboardCounts() {
    const suboutlet = await this.dashboardService.suboutletCounts();
    const deliveryboy = await this.dashboardService.deliveryboyCounts();
    const admin = await this.dashboardService.adminCounts();
    const superadmin = await this.dashboardService.superadminCounts();
    const staff = await this.dashboardService.staffCounts();
    const basekitchen = await this.dashboardService.basekitchenCounts();
    const cartorder = await this.dashboardService.cartCounts();
    const draftorder = await this.dashboardService.draftCounts();
    const orderd = await this.dashboardService.orderdCounts();
    const dispatched = await this.dashboardService.dispatchedCounts();
    const delivered = await this.dashboardService.deliveredCounts();
    const returned = await this.dashboardService.returnedCounts();
    const partiallyDelivered = await this.dashboardService.partialCounts();
    const totalStaffs = await this.dashboardService.totalStaffsCounts();
    const totalOrders = await this.dashboardService.totalOrdersCounts();
    const totalOutlets = await this.dashboardService.totalOutletsCounts();
    return {
      suboutlet,
      deliveryboy,
      admin,
      superadmin,
      staff,
      basekitchen,
      cartorder,
      draftorder,
      orderd,
      dispatched,
      delivered,
      returned,
      partiallyDelivered,
      totalStaffs,
      totalOrders,
      totalOutlets
    };
  }
}
