import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Brackets, Repository } from 'typeorm';
import { CompanySubCategoryDto, BoolStatusDto } from './dto/company-sub-category.dto';
import { CompanySubCategory } from './entities/company-sub-category.entity';

@Injectable()
export class CompanySubCategoryService {
  constructor(
    @InjectRepository(CompanySubCategory)
    private readonly repo: Repository<CompanySubCategory>,
  ) {}

  async create(dto: CompanySubCategoryDto) {
    // JSON.parse(dto.subCategoryId)
    // JSON.parse(dto.subCategoryId).forEach(element => {
    // 
    // });
    const result = await this.repo.findOne({
      where: {
        companyDetailId: dto.companyDetailId,
        subCategoryId: dto.subCategoryId,
      },
    });
    if (result) {
      throw new ConflictException('Already exists!');
    }
    const obj = Object.create(dto);
    return this.repo.save(obj);
  }

  async status(id: string, dto: BoolStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return this.repo.remove(result);
  }
}
