/// <reference types="multer" />
import { Account } from 'src/account/entities/account.entity';
import { NotifyService } from 'src/notify/notify.service';
import { PaginationAllDto, TicketAnswerDto, TicketDto, PaginationReportDto } from './dto/ticket.dto';
import { TicketsService } from './tickets.service';
export declare class TicketsController {
    private readonly ticketsService;
    private readonly notifyService;
    constructor(ticketsService: TicketsService, notifyService: NotifyService);
    create(dto: TicketDto, user: Account, file: Express.Multer.File): Promise<any>;
    findAll(dto: PaginationAllDto): Promise<{
        result: import("./entities/ticket.entity").Ticket[];
        total: number;
    }>;
    findReportAll(dto: PaginationReportDto): Promise<{
        result: import("./entities/ticket.entity").Ticket[];
        total: number;
    }>;
    findByUser(id: string, dto: PaginationAllDto): Promise<{
        result: import("./entities/ticket.entity").Ticket[];
        total: number;
    }>;
    find(user: Account, dto: PaginationAllDto): Promise<{
        result: import("./entities/ticket.entity").Ticket[];
        total: number;
    }>;
    findOne(id: string): Promise<number>;
    update(id: string, dto: TicketAnswerDto, user: Account): Promise<import("./entities/ticket.entity").Ticket & TicketAnswerDto>;
}
