import { BoolStatusDto } from 'src/common/dto/bool-status.dto';
import { OrderStatus } from 'src/enum';
import { Repository } from 'typeorm';
import { SubCategoryDto } from './dto/sub-category.dto';
import { SubCategory } from './entities/sub-category.entity';
export declare class SubCategoryService {
    private readonly repo;
    constructor(repo: Repository<SubCategory>);
    create(dto: SubCategoryDto): Promise<any>;
    findAll(limit: number, offset: number, keyword: string, status: boolean, categoryId: string): Promise<{
        result: SubCategory[];
        total: number;
    }>;
    findSub(limit: number, offset: number, keyword: string): Promise<{
        result: SubCategory[];
        total: number;
    }>;
    find(limit: number, offset: number, keyword: string, categoryId: string): Promise<{
        result: SubCategory[];
        total: number;
    }>;
    findsubcate(categoryId: string): Promise<{
        result: SubCategory[];
    }>;
    findByMultiCat(limit: number, offset: number, keyword: string, categories: any): Promise<{
        result: SubCategory[];
        total: number;
    }>;
    products(limit: number, offset: number, keyword: string, status: OrderStatus, cartId: string, outletDetailId: string, outletBranchId: string): Promise<{
        data: any[];
        order: SubCategory;
    }>;
    findOne(id: string): Promise<SubCategory>;
    update(id: string, dto: SubCategoryDto): Promise<SubCategory & {
        name: string;
        foodType: import("src/enum").ItemType;
    }>;
    image(id: string, image: string): Promise<SubCategory & {
        image: string;
        imageName: string;
    }>;
    status(id: string, dto: BoolStatusDto): Promise<SubCategory & BoolStatusDto>;
}
