/// <reference types="multer" />
import { Account } from 'src/account/entities/account.entity';
import { BoolStatusDto } from 'src/common/dto/bool-status.dto';
import { PaginationDto } from 'src/common/dto/pagination.dto';
import { PaginationPDto, PaginationSDto, SubCategoryDto, ProductPaginationDto } from './dto/sub-category.dto';
import { SubCategoryService } from './sub-category.service';
export declare class SubCategoryController {
    private readonly subCategoryService;
    constructor(subCategoryService: SubCategoryService);
    create(dto: SubCategoryDto): Promise<any>;
    findAll(query: PaginationSDto, categoryId: string): Promise<{
        result: import("./entities/sub-category.entity").SubCategory[];
        total: number;
    }>;
    find(query: PaginationDto, categoryId: string): Promise<{
        result: import("./entities/sub-category.entity").SubCategory[];
        total: number;
    }>;
    findsubcate(categoryId: string): Promise<{
        result: import("./entities/sub-category.entity").SubCategory[];
    }>;
    findByMultiCat(query: PaginationPDto): Promise<{
        result: import("./entities/sub-category.entity").SubCategory[];
        total: number;
    }>;
    products(query: ProductPaginationDto, user: Account): Promise<{
        data: any[];
        order: import("./entities/sub-category.entity").SubCategory;
    }>;
    findOne(id: string): Promise<import("./entities/sub-category.entity").SubCategory>;
    update(id: string, dto: SubCategoryDto): Promise<import("./entities/sub-category.entity").SubCategory & {
        name: string;
        foodType: import("src/enum").ItemType;
    }>;
    status(id: string, dto: BoolStatusDto): Promise<import("./entities/sub-category.entity").SubCategory & BoolStatusDto>;
    image2(id: string, file: Express.Multer.File): Promise<import("./entities/sub-category.entity").SubCategory & {
        image: string;
        imageName: string;
    }>;
}
