import { Cache } from 'cache-manager';
import { Menu } from 'src/menus/entities/menu.entity';
import { Repository } from 'typeorm';
import { StaffDetailDto, UpdateStaffDetailDto } from './dto/staff-detail.dto';
import { StaffDetail } from './entities/staff-detail.entity';
export declare class StaffDetailsService {
    private readonly repo;
    private readonly menuRepo;
    private readonly cacheManager;
    constructor(repo: Repository<StaffDetail>, menuRepo: Repository<Menu>, cacheManager: Cache);
    create(dto: StaffDetailDto): Promise<any>;
    update(accountId: string, dto: UpdateStaffDetailDto): Promise<StaffDetail & UpdateStaffDetailDto>;
    findOne(accountId: string): Promise<StaffDetail>;
    profile(id: string): Promise<{
        user: StaffDetail;
        perms: Menu[];
    }>;
    image(accountId: string, image: string): Promise<StaffDetail & {
        profile: string;
        profileName: string;
    }>;
    pan(accountId: string, image: string): Promise<StaffDetail & {
        pan: string;
        panName: string;
    }>;
    aadhar(accountId: string, image: string): Promise<StaffDetail & {
        aadhar: string;
        aadharName: string;
    }>;
    private delStaffDetail;
    private getStaffDetail;
}
