import { Account } from 'src/account/entities/account.entity';
import { PaginationSDto, StatusDto } from 'src/outlet-branch/dto/outlet-branch.dto';
import { CreateOutletDetailDto, OutletDetailDto, TimeIncreaseDto } from './dto/outlet-detail.dto';
import { OutletDetailsService } from './outlet-details.service';
export declare class OutletDetailsController {
    private readonly outletDetailsService;
    constructor(outletDetailsService: OutletDetailsService);
    create(createOutletDetailDto: CreateOutletDetailDto, user: Account): Promise<any>;
    findAll(dto: PaginationSDto): Promise<{
        result: import("./entities/outlet-detail.entity").OutletDetail[];
        total: number;
    }>;
    outletProfile(id: string): Promise<import("./entities/outlet-detail.entity").OutletDetail>;
    find(dto: PaginationSDto, branchId: string): Promise<{
        result: import("./entities/outlet-detail.entity").OutletDetail[];
        total: number;
    }>;
    update(id: string, updateOutletDetailDto: OutletDetailDto): Promise<import("./entities/outlet-detail.entity").OutletDetail & OutletDetailDto>;
    status(id: string, dto: StatusDto): Promise<import("./entities/outlet-detail.entity").OutletDetail & StatusDto>;
    timeIncrease(id: string, dto: TimeIncreaseDto): Promise<import("./entities/outlet-detail.entity").OutletDetail & TimeIncreaseDto>;
}
