"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutletBranchController = void 0;
const common_1 = require("@nestjs/common");
const outlet_branch_dto_1 = require("./dto/outlet-branch.dto");
const outlet_branch_service_1 = require("./outlet-branch.service");
const passport_1 = require("@nestjs/passport");
const permissions_decorator_1 = require("../auth/decorators/permissions.decorator");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
const enum_1 = require("../enum");
let OutletBranchController = class OutletBranchController {
    constructor(outletBranchService) {
        this.outletBranchService = outletBranchService;
    }
    create(createOutletBranchDto) {
        return this.outletBranchService.create(createOutletBranchDto);
    }
    findAll(dto) {
        return this.outletBranchService.findAll(dto);
    }
    findOne(id) {
        return this.outletBranchService.findOne(id);
    }
    find(dto, companyId) {
        return this.outletBranchService.find(dto, companyId);
    }
    update(id, updateOutletBranchDto) {
        return this.outletBranchService.update(id, updateOutletBranchDto);
    }
    status(id, dto) {
        return this.outletBranchService.status(id, dto);
    }
};
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.CREATE, 'outlet_branch']),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [outlet_branch_dto_1.OutletBranchDto]),
    __metadata("design:returntype", void 0)
], OutletBranchController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'outlet_branch']),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [outlet_branch_dto_1.PaginationSDto]),
    __metadata("design:returntype", void 0)
], OutletBranchController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'outlet_branch']),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OutletBranchController.prototype, "findOne", null);
__decorate([
    (0, common_1.Get)('list/:companyId'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [outlet_branch_dto_1.PaginationSDto, String]),
    __metadata("design:returntype", void 0)
], OutletBranchController.prototype, "find", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'outlet_branch']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, outlet_branch_dto_1.OutletBranchDto]),
    __metadata("design:returntype", void 0)
], OutletBranchController.prototype, "update", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'outlet_branch']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, outlet_branch_dto_1.StatusDto]),
    __metadata("design:returntype", void 0)
], OutletBranchController.prototype, "status", null);
OutletBranchController = __decorate([
    (0, common_1.Controller)('outlet-branch'),
    __metadata("design:paramtypes", [outlet_branch_service_1.OutletBranchService])
], OutletBranchController);
exports.OutletBranchController = OutletBranchController;
//# sourceMappingURL=outlet-branch.controller.js.map