import { OrderStatus } from 'src/enum';
import { NotifyService } from 'src/notify/notify.service';
import { OutletDetailsService } from 'src/outlet-details/outlet-details.service';
import { Repository } from 'typeorm';
import { OrderDto, PaginationAllDto, PaginationAllReportDto, PaginationReportDto, PaginationDto, RemarkDto, SearchListDto, StatusDto, StatusOrderDto, UpdateOrderDto } from './dto/order.dto';
import { Order } from './entities/order.entity';
export declare class OrdersService {
    private readonly repo;
    private readonly outletDetailService;
    private readonly notifyService;
    constructor(repo: Repository<Order>, outletDetailService: OutletDetailsService, notifyService: NotifyService);
    create(dto: OrderDto, outletDetailId: string): Promise<any>;
    update(date: any, dto: UpdateOrderDto[], id: string, fcm: string): Promise<{
        result: UpdateOrderDto[];
    }>;
    private findFirstWords;
    updateQty(id: string, dto: StatusOrderDto): Promise<Order & StatusOrderDto>;
    remark(id: string, dto: RemarkDto): Promise<{
        result: Order & RemarkDto;
    }>;
    updateDeliveryBoy(cartId: string, accountId: string, status: any): Promise<import("typeorm").UpdateResult>;
    signature(cartId: string, image: string): Promise<{
        url: string;
    }>;
    returnProduct(id: string, image: string): Promise<{
        url: string;
    }>;
    status(dto: StatusOrderDto[]): {
        result: StatusOrderDto[];
    };
    outletCartList(outletDetailId: string, dto: StatusDto): Promise<{
        result: any[];
        total: number;
    }>;
    adminOrderList(dto: PaginationAllDto): Promise<{
        result: Order[];
        total: number;
    }>;
    adminOrderReport(dto: PaginationAllReportDto): Promise<{
        result: any[];
    }>;
    findReportAll(dto: PaginationReportDto): Promise<{
        result: any[];
        total: number;
    }>;
    outletOrderList(outletDetailId: string, dto: PaginationDto): Promise<{
        result: Order[];
        total: number;
    }>;
    outletOrderItems(cartId: string): Promise<{
        result: Order[];
        total: number;
    }>;
    printOrderItems(cartId: string): Promise<{
        result: Order[];
        total: number;
    }>;
    findGroupByDelivery(accountId: string, dto: SearchListDto): Promise<{
        result: Order[];
        total: number;
    }>;
    findGroupDeliveryHistory(accountId: string, dto: PaginationDto): Promise<{
        result: Order[];
        total: number;
    }>;
    findOne(id: string): Promise<Order>;
    removeorders(id: string): Promise<void>;
    removesingle(id: string): Promise<Order & {
        status: OrderStatus;
    }>;
}
