"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeedbackService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const feedback_entity_1 = require("./entities/feedback.entity");
let FeedbackService = class FeedbackService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        const result = await this.repo.findOne({
            where: { accountId: dto.accountId, desc: dto.desc },
        });
        if (result) {
            throw new common_1.ConflictException('Thank you for your valuable feedback!');
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('feedback')
            .leftJoinAndSelect('feedback.account', 'account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .select([
            'feedback.id',
            'feedback.desc',
            'feedback.createdAt',
            'feedback.status',
            'account.id',
            'staffDetail.name',
        ])
            .where('feedback.status = :status', { status: dto.status })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('feedback.desc LIKE :desc', {
                desc: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'feedback.createdAt': 'DESC' })
            .skip(dto.offset)
            .take(dto.limit)
            .getManyAndCount();
        return { result, total };
    }
    async find() {
        return this.repo
            .createQueryBuilder('feedback')
            .leftJoinAndSelect('feedback.account', 'account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .select([
            'feedback.id',
            'feedback.desc',
            'account.id',
            'staffDetail.name',
        ])
            .where('feedback.status = :status', { status: true })
            .orderBy({ 'feedback.createdAt': 'DESC' })
            .skip(0)
            .take(10)
            .getMany();
    }
    async update(id, dto) {
        const result = await this.repo.findOne({
            where: { id },
        });
        if (!result) {
            throw new common_1.NotFoundException('Feedback not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async status(id, dto) {
        const result = await this.repo.findOne({
            where: { id },
        });
        if (!result) {
            throw new common_1.NotFoundException('Feedback not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
};
FeedbackService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(feedback_entity_1.Feedback)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], FeedbackService);
exports.FeedbackService = FeedbackService;
//# sourceMappingURL=feedback.service.js.map