import { Repository } from 'typeorm';
import { CreateContactUsDto, UpdateContactUsDto } from './dto/contact-us.dto';
import { PaginationDto } from './dto/pagination.dto';
import { ContactUs } from './entities/contact-us.entity';
export declare class ContactUsService {
    private readonly repo;
    constructor(repo: Repository<ContactUs>);
    create(dto: CreateContactUsDto): Promise<any>;
    findAll(dto: PaginationDto): Promise<{
        result: ContactUs[];
        total: number;
    }>;
    findOne(contactUsId: string): Promise<ContactUs>;
    update(contactUsId: string, dto: UpdateContactUsDto, accountId: string): Promise<ContactUs & {
        answer: string;
        accountId: string;
    }>;
}
